<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once '../../config/app.php';

if(isset($_SESSION['ADMIN_ID'])) {
    $user = R::load('admins', $_SESSION['ADMIN_ID']);

    $users = R::findAll('users');
    
    if(isset($_GET['user'])) {
        $user_id = $_GET['user'];
        $list_beneficiaries = R::findAll('beneficiaries', 'user_id=?', [$user_id]);
        
    } else {
        die('Invalid request');
    }

} else {
    // Redirect user to login
    header('location: login.php');
    exit();
}



if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $errors = [];

    $name = htmlspecialchars(strip_tags(trim($_POST['name'])));
    $bank = htmlspecialchars(strip_tags(trim($_POST['bank'])));
    $account = htmlspecialchars(strip_tags(trim($_POST['account'])));
    $routing = htmlspecialchars(strip_tags(trim($_POST['routing'])));
    $user_id = htmlspecialchars(strip_tags(trim($_POST['user_id'])));
    // $created_at = now();

    if (empty($name)) $errors[] = 'Account name is required'; 
    if (empty($bank)) $errors[] = 'Bank name is required'; 
    if (empty($account)) $errors[] = 'Account number is required';

    if(empty($errors)) {

        $beneficiary = R::dispense( 'beneficiaries' );

        $beneficiary->name = $name;
        $beneficiary->bank = $bank;
        $beneficiary->account = $account;
        $beneficiary->routing = $routing;
        $beneficiary->user_id = $user_id;
        // $beneficiary->created_at = $account_created_at;

        if(R::store($beneficiary)) {
            unset($bank, $account, $name);
            $flashMessage = 'Beneficiary successfully added';
            // header('location: beneficiaries.php?user='.$user_id);
        }

    }
}

?>

<?php require $base_url . 'app/includes/head.php'; ?>

<?php require $base_url . 'app/includes/nav.php'; ?>


    <div class="container">
        <p>
          <?php if (isset($flashMessage)): ?>
            <div class="alert alert-success text-center">
            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                <?php echo $flashMessage; ?>
                <?php unset($flashMessage); ?>
            </div>
          <?php endif; ?>
            
        </p>
        
        <h1 style="margin: 30px 0">
            <i class="fas fa-user-lock"></i> Add Beneficiary
            <span class="pull-right">
<!--                <a href="new_user.php" class="btn btn-primary btn-xs"><i class="fa fa-plus"></i> ADD ACCOUNT</a>-->
            </span>
        </h1>
        <div class="border border-gray-200">

            <div class="panel-body">
                <div class="row">
                    <div class="col-md-5">
                        <p>
                            <!-- Put error messages here -->
                            <?php if (!empty($errors)): ?>
                        <div class="alert alert-danger text-center">
                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                            <?php echo implode('<p></p>', $errors); ?>
                        </div>
                        <?php endif; ?>

                        </p>
                        
                        <section>
                            <h4 class="mt-10" style="margin-bottom: 10px">Add a beneficiary to database. <small class="text-red-500">Senders and receivers of your transactions</small></h4>
                        
                            <form name="horizontal" action="<?php $_SERVER['PHP_SELF']; ?>" method="post">
                                
                                <input type="hidden" name="user_id" value="<?php echo $user_id; ?>">
    
    
                                <div class="form-group">
                                    <label for="name">Name</label>
                                    <input class="form-control" id="name" type="text" name="name" placeholder="Account Name" value="<?php echo (isset($name))? $name: ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="type">Bank Name</label>
                                    <input class="form-control" id="bank" type="text" name="bank" placeholder="Bank Name" value="<?php echo (isset($bank))? $bank: ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="type">Account Number</label>
                                    <input class="form-control" id="account" type="text" name="account" placeholder="Account Number" value="<?php echo (isset($account))? $account: ''; ?>">
                                </div>
                                <div class="form-group">
                                    <label for="type">Routing</label>
                                    <input class="form-control" id="routing" type="text" name="routing" placeholder="Routing Number">
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary"><i class="fa fa-plus"></i> Add Beneficiary</button>
                                </div>
                            </form>
                        </section>
                        
                        
                        <?php if(count($list_beneficiaries)): ?>
                                    <table class="my-16 w-full">
                                        <thead>
                                        <tr>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Name
                                            </th>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Bank
                                            </th>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Account Number
                                            </th>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Routing
                                            </th>
                                            <th class="px-6 py-3 border-b border-gray-200 bg-gray-50"></th>
                                        </tr>
                                        </thead>
                                    <?php foreach ($list_beneficiaries as $beneficiary): ?>
                                        <tbody class="bg-white">
                                        <tr>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <?= $beneficiary->name; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <?= $beneficiary->bank; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <?= $beneficiary->account; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <?= $beneficiary->routing; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap text-right border-b border-gray-200 text-xl leading-5 font-medium">
                                                <div>
                                                    <span>
                                                   <a href="edit_beneficiary.php?beneficiary=<?= $beneficiary->id; ?>" class="inline-flex justify-center rounded-md border border-gray-300 px-5 uppercase py-3 bg-white text-sm leading-5 font-medium text-gray-700 hover:text-gray-500 focus:outline-none focus:border-blue-300 focus:shadow-outline-blue active:bg-gray-50 active:text-gray-800 transition ease-in-out duration-150"><i class="fas fa-user-edit" style="margin-right: 10px"></i> Edit Beneficiary</a>
                                               </span>
                                                </div>
                                            </td>
                                        </tr>
                                        </tbody>
                                    <?php endforeach; ?>


                                    </table>

                                <?php else: ?>

                                    <div class="text-center mt-32 text-gray-400 text-gray-600">
                                        <span class="text-5xl">
                                            ¯\_(ツ)_/¯
                                        </span>
                                        <p class="mb-32 mt-4 text-2xl">
                                            You don't have any beneficiary yet <br>
                                            Add a beneficiary to get started
                                        </p>
                                    </div>

                                <?php endif; ?>
                                
                    
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php include $base_url . 'app/includes/footer.php'; ?>