<?php

require '../../../config/app.php';

// User
if(isset($_SESSION['USER'])) {
    $user = R::load('users', $_SESSION['USER']);

    $adminProfile = R::load('admins', DEFAULT_ADMIN_ID);

    // Accounts related to user
    $tickets = R::findAll('messages', 'user_id = ? ORDER BY created_at DESC', [$user->id]);

    // Transactions related to user
//    $transactions = R::findAll('transactions', 'user_id = ?', [$user->id]);

    // Beneficiaries
    // $beneficiaries = R::load('beneficiaries', 'user_id', [$user->id]);

    $ticket_number = 'SUPQRY20' . date('Y') . mt_rand(1, 1000);

} else {
    // Redirect user to login
    header('location: layout.php');
}

if(!isset($_GET['number'])) {
    die('transaction number does not exist');
}

$transaction_number = $_GET['number'];
$transaction_details = R::load('transactions', $transaction_number);
$beneficiary = R::load('beneficiaries', $transaction_details->beneficiary);
$acount  = R::load('accounts', $transaction_details->account_id);

$error = [];

if(isset($_POST['SEND_MESSAGE'])) {

    $ticket_number = htmlspecialchars(strip_tags(trim($_POST['ticket_number'])));
    $enquiry = htmlspecialchars(strip_tags(trim($_POST['enquiry'])));
    $send_to_account_manager = htmlspecialchars(strip_tags(trim($_POST['send_to_account_manager'])));
    $user_id = htmlspecialchars(strip_tags(trim($_POST['user_id'])));

    if (!$send_to_account_manager) {
        $enquiry_type = htmlspecialchars(strip_tags(trim($_POST['enquiry_type'])));
    }

    if (empty($enquiry)) {
        $error['enquiry'] = true;
    }

    if (!sizeof($error) > 0) {

        $ticket = R::dispense( 'messages' );
        $ticket->ticket_number = $ticket_number;
        $ticket->enquiry = $enquiry;

        if (!$send_to_account_manager) {
            $ticket->enquiry_type = $enquiry_type;
            $ticket->for_account_manager = 1;
        } else {
            $ticket->for_support = 1;
        }

        $ticket->send_to_account_manager = $send_to_account_manager;
        $ticket->user_id = $user_id;
        $ticket->created_at = new DateTime('now');

        if (R::store($ticket)) {
            if($send_to_account_manager) {
                $_SESSION['CREATED'] = 'Message successfully sent to your account manager';
            } else {
                $_SESSION['CREATED'] = 'Ticket successfully added';
            }
            header('location: messages.php');
            exit();
        }
    }
}

?>

<?php require $base_url . 'app/account/new/layouts/head.php'; ?>

<!-- component -->
<div class="w-full flex flex-row flex-wrap" xmlns="http://www.w3.org/1999/html">


    <div class="w-full h-screen flex flex-row flex-wrap justify-center ">

            <?php include $base_url . 'app/account/new/layouts/navigation.php'; ?>

        </div>

        <!-- End Navbar -->

        <?php if ($transaction_details->number == '47765f615346'): ?>
        
        <div class="w-full md:w-3/4 lg:w-4/5 p-5 md:px-12 lg:24 h-full overflow-x-scroll antialiased mt-16 md:mt-2">

            <div class="bg-white w-full mt-8">
                <div class="flex flex-row justify-between">     
                    <div class="flex flex-col top-heading">
                        <span class=" text-4xl text-gray-700">
                            <span>
                                Transaction Details
                            </span>
                        </span>
                        <span class="text-gray-800">
                            Transaction Date: <?php echo $transaction_details->transfer_date; ?><span class="text-gray-700"></span></span> <span class="text-gray-800">
                            Confirmation Number: <span class="uppercase"><?php echo $transaction_details->number; ?></span><span class="text-gray-700"></span></span>
                            <small class="text-gray-800">
                            Transaction Type: <span class="uppercase">
                                <?php if($transaction_details->credit): ?>
                                    <span class="text-green-700 font-semibold">
                                        <i class="fa-solid fa-rotate-right"></i> Credit
                                    </span>
                                <?php  else: ?>
                                    <span class="text-red-700 font-semibold">
                                        <i class="fa-solid fa-rotate-left"></i> Debit
                                    </span>
                                <?php  endif; ?>
                            </span><span class="text-gray-700"></span></small>
                    </div>
                    <div class="flex flex-row">
                        <?php  include $base_url . 'app/account/new/layouts/top_left_nav.php'; ?>
                    </div>
                </div>
            </div>

            <?php include $base_url . 'app/account/new/layouts/alerts.php' ?>

            <div class="mt-3 md:flex md:flex-col">


                <div class="bg-white mt-3">
                    <div class="md:flex md:flex-row justify-between">

                        <div class="md:w-1/2">
                            <small class="mb-5">
                                You have received a transaction. There is a 45 day open window to open a dispute with your account manager.
                            </small>
                            <div class="mr-10 mt-10">

                                <p class="mb-10">
                                    <span class="font-bold text-gray-700">Transfer Amount: </span>
                                    <span class="font-bold <?php if($transaction_details->credit) { echo "text-green-700"; } else { echo "text-red-700"; } ?>">
                                        <?php //echo interpret_currency($adminProfile->currency); ?>
                                        <?php
                                            echo interpret_currency($adminProfile->currency) . number_format($transaction_details->amount, 2);
                                        ?>
                                    </span>
                                </p>
                                
                                <p class="mb-10">
                                    <span class="blok font-bold text-gray-700">Sending Account: </span>
                                    <span class="text-purple-s600">
                                        <span class="block"> 
                                            <span class="font-semibold">Name: </span>
                                            <?php
                                                echo "Uni Gold UAE Plc";
                                            ?>
                                        </span>
                                       
                                        <span class="block"> 
                                            <span class="font-semibold">Account Number: </span>
                                            <?php
                                                echo "4002930009111202";
                                            ?>
                                        </span>
                                      
                                    </span>
                                </p>
                                
                                
                                <p class="mb-10">
                                    <span class="block font-bold text-gray-900">Beneficiary Account: </span>
                                    <span class="text-purple-s600">
                                        <span class="block"> 
                                            <span class="font-semibold">Name: </span>
                                            <?php
                                                echo "Nickert Charles Dennis";
                                            ?>
                                        </span>
                                        <span class="block"> 
                                            <span class="font-semibold">Bank Name: </span> <?php
                                                echo "Same Bank Transfer";
                                            ?>
                                        </span>
                                        <span class="block"> 
                                            <span class="font-semibold">Account Number: </span>
                                            <?php
                                                echo "4002930003129001";
                                            ?>
                                        </span>
                                        <span class=block> 
                                            <span class="font-semibold">Routing Number: </span> 
                                            <?php
                                                echo "n/a";
                                            ?>
                                        </span>
                                    </span>
                                </p>
                                
                                <p class="mb-10">
                                    <span class="font-bold text-gray-900">Transfer Memo: </span>
                                    <span class="text-purple-d600 font-ssemibold">
                                        <span><?php echo "Payment to Charles - Gold bars"; ?></span>
                                    </span>
                                </p>
                                
                                <p class="mb-1">
                                    <span class="font-bold text-gray-900">Transaction Status: </span>
                                    <span class="text-purple-600 font-semibold">
                                        <?php if($transaction_details->completed): ?>
                                        
                                       <div class="font-bold text-green-600">
                                            <i class="fa-solid fa-check"></i> 
                                            <?php echo "completed"; ?>
                                        </div>
                                        
                                        <?php else: ?>
                                        
                                        <?php  if($transaction_details->id == 5 || $transaction_details->id == 6): ?>
                                            <div class="font-bold text-yellow-600">
                                            <i class="fa-solid fa-triangle-exclamation"></i> 
                                            <?php echo "Cancelled"; ?>
                                        </div>
                                        <?php else: ?>
                                        <div class="font-bold text-red-600">
                                            <i class="fa-solid fa-circle-xmark"></i>   
                                            <?php echo "Cancelled"; ?>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php endif; ?>
                                        
                                    </span>
                                </p>
                                
                                
                            </div>
                        </div>

                        

                    </div>
                </div>


            </div>
        
        <?php else: ?>
        
        <div class="w-full md:w-3/4 lg:w-4/5 p-5 md:px-12 lg:24 h-full overflow-x-scroll antialiased mt-16 md:mt-2">

            <div class="bg-white w-full mt-8">
                <div class="flex flex-row justify-between">     
                    <div class="flex flex-col top-heading">
                        <span class=" text-4xl text-gray-700">
                            <span>
                                Transaction Details
                            </span>
                        </span>
                        <span class="text-gray-800">
                            Transaction Date: <?php echo $transaction_details->transfer_date; ?><span class="text-gray-700"></span></span> <span class="text-gray-800">
                            Confirmation Number: <span class="uppercase"><?php echo $transaction_details->number; ?></span><span class="text-gray-700"></span></span>
                            <small class="text-gray-800">
                            Transaction Type: <span class="uppercase">
                                <?php if($transaction_details->credit): ?>
                                    <span class="text-green-700 font-semibold">
                                        <i class="fa-solid fa-rotate-right"></i> Credit
                                    </span>
                                <?php  else: ?>
                                    <span class="text-red-700 font-semibold">
                                        <i class="fa-solid fa-rotate-left"></i> Debit
                                    </span>
                                <?php  endif; ?>
                            </span><span class="text-gray-700"></span></small>
                    </div>
                    <div class="flex flex-row">
                        <?php  include $base_url . 'app/account/new/layouts/top_left_nav.php'; ?>
                    </div>
                </div>
            </div>

            <?php include $base_url . 'app/account/new/layouts/alerts.php' ?>

            <div class="mt-3 md:flex md:flex-col">


                <div class="bg-white mt-3">
                    <div class="md:flex md:flex-row justify-between">

                        <div class="md:w-1/2">
                            <small class="mb-5">
                                Thank you for using our banking services. See all transaction details below.
                                You have 45 days from the date of the transaction to open a dispute with your account manager.
                            </small>
                            <div class="mr-10 mt-10">

                                <p class="mb-10">
                                    <span class="font-bold text-gray-700">Transfer Amount: </span>
                                    <span class="font-bold <?php if($transaction_details->credit) { echo "text-green-700"; } else { echo "text-red-700"; } ?>">
                                        <?php //echo interpret_currency($adminProfile->currency); ?>
                                        <?php
                                            echo interpret_currency($adminProfile->currency) . number_format($transaction_details->amount, 2);
                                        ?>
                                    </span>
                                </p>
                                
                                <p class="mb-10">
                                    <span class="blok font-bold text-gray-700"><?php if($transaction_details->credit) { echo "Receiving"; } else { echo "Sending"; } ?> Account: </span>
                                    <span class="text-purple-s600">
                                        <span class="block"> 
                                            <span class="font-semibold">Name: </span>
                                            <?php
                                                echo $user->name;
                                            ?>
                                        </span>
                                       
                                        <span class="block"> 
                                            <span class="font-semibold">Account Number: </span>
                                            <?php
                                                echo $acount->number;
                                            ?>
                                        </span>
                                      
                                    </span>
                                </p>
                                
                                
                                <p class="mb-10">
                                    <span class="block font-bold text-gray-900"><?php if($transaction_details->credit) { echo "Sender"; } else { echo "Receiver"; } ?> Details: </span>
                                    <span class="text-purple-s600">
                                        <span class="block"> 
                                            <span class="font-semibold">Name: </span>
                                            <?php
                                                echo $beneficiary->name;
                                            ?>
                                        </span>
                                        <span class="block"> 
                                            <span class="font-semibold">Bank Name: </span> <?php
                                                echo $beneficiary->bank;
                                            ?>
                                        </span>
                                        <span class="block"> 
                                            <span class="font-semibold">Account Number: </span>
                                            <?php
                                                echo "*************" . substr($beneficiary->account, -4);
                                            ?>
                                        </span>
                                        <span class=block> 
                                            <span class="font-semibold">Routing Number: </span> 
                                            <?php
                                                echo "********" . substr($beneficiary->routing, -4);
                                            ?>
                                        </span>
                                    </span>
                                </p>
                                
                                <p class="mb-10">
                                    <span class="font-bold text-gray-900">Transfer Memo: </span>
                                    <span class="text-purple-d600 font-ssemibold">
                                        <span><?php echo $transaction_details->memo; ?></span>
                                    </span>
                                </p>
                                
                                <p class="mb-1">
                                    <span class="font-bold text-gray-900">Transaction Status: </span>
                                    <span class="text-purple-600 font-semibold">
                                        <?php if($transaction_details->completed): ?>
                                        
                                       <div class="font-bold text-green-600">
                                            <i class="fa-solid fa-check"></i> 
                                            <?php echo "completed"; ?>
                                        </div>
                                        
                                        <?php else: ?>
                                        
                                        <?php  if($transaction_details->id == 5 || $transaction_details->id == 6): ?>
                                            <div class="font-bold text-yellow-600">
                                            <i class="fa-solid fa-triangle-exclamation"></i> 
                                            <?php echo "Cancelled"; ?>
                                        </div>
                                        <?php else: ?>
                                        <div class="font-bold text-yellow-600">
                                            <i class="fa-solid fa-circle-xmark"></i>   
                                            <?php if($transaction_details->completed == 2): ?>
                                                <?php echo "Cancelled"; ?>
                                            <?php else: ?>
                                                <span class="text-yellow-600">
                                                    <?php echo "Cancelled"; ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php endif; ?>
                                        
                                    </span>
                                </p>
                                
                                
                            </div>
                        </div>

                        

                    </div>
                </div>


            </div>
        
        <?php endif; ?>


            <?php include $base_url . 'app/account/new/layouts/sub_footer.php'; ?>




        </div>

        <?php require $base_url . 'app/account/new/layouts/footer.php'; ?>
