<div class="md:w-full mt-10">
    <h3 class="mb-3 sub-heading">Transactions</h3>
    <div class="flex flex-col rounded-md mr-5" style="background-color: #F9F9F9">

        <!-- component -->
        <?php if(!empty($transactions)): ?>

            <table class="min-w-full leading-normal">
            <thead>
            <tr>
                <th
                        class="px-5 py-3 border-b-2 border-gray-200 bg-gray-100 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider" style="background-color: #f9f9f9">
                    TXID
                </th>
                <th
                        class="px-5 py-3 border-b-2 border-gray-200 bg-gray-100 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider" style="background-color: #f9f9f9">
                    Transfer date
                </th>
                <th
                        class="px-5 py-3 border-b-2 border-gray-200 bg-gray-100 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider" style="background-color: #f9f9f9">
                    Status
                </th>
                <th
                        class="px-5 py-3 border-b-2 border-gray-200 bg-gray-100 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider" style="background-color: #f9f9f9">
                    Type
                </th>
                <th
                        class="px-5 py-3 border-b-2 border-gray-200 bg-gray-100 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider" style="background-color: #f9f9f9">
                    Amount
                </th>
            </tr>
            </thead>
            <tbody>

            <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td class="px-5 py-4 border-b border-gray-200 bg-white text-sm">
                            <div class="flex items-center">
                                <p class="text-gray-900 whitespace-no-wrap">
                                    <a class="text-blue-700 font-bold" href="transaction-details.php?number=<?php echo $transaction->id; ?>">
                                        <i class="fa-brands fa-readme"></i>
                                         <?php echo strtoupper($transaction->number); ?>
                                    </a>
                                </p>
                            </div>
                        </td>
                        <td class="px-5 py-4 border-b border-gray-200 bg-white text-sm">
                            <div class="flex items-center">
                                <p class="text-gray-900 whitespace-no-wrap"> <?php echo substr($transaction->transfer_date, 0, 10); ?> </p>
                            </div>
                        </td>
                        <td class="px-5 py-4 border-b border-gray-200 bg-white text-sm">
                            <p class="whitespace-no-wrap">
                                
                                <?php if($transaction->completed): ?>
                                <i class="fa-solid fa-check font-semibold text-green-600"></i>
                                    <span class="text-sm font-semibold text-green-600">Completed</span>
                                <?php else: ?>
                                    <span class="text-sm font-semibold text-red-700">
                                        <?php if($transaction->id == 5 || $transaction->id == 6): ?>
                                            <span>
                                                 <?php echo 'Cancelled'; ?>
                                                 <!--<?php echo 'On Hold'; ?>-->
                                            </span>
                                         <?php else: ?>
                                            <span>
                                                 <?php echo 'Cancelled'; ?>
                                                  <!--<?php echo 'Pending'; ?>-->
                                            </span>
                                        <?php endif; ?>
                                    </span>
                                <?php endif; ?>
                            </p>
                            <p>
<!--                                Monthly-->
                            </p>
                        </td>
                        <td class="px-5 py-4 border-b border-gray-200 bg-white text-sm">
                            <span class="text-gray-900 whitespace-no-wrap uppercase">
                                <?php if($transaction->credit): ?>
                                    <span class="text-green-500 font-semibold">+ cdt</span>
                                <?php else: ?>
                                    <span class="text-red-500 font-semibold">- dbt</span>
                                <?php endif; ?>
                            </span>
                        </td>
                        
                        <td class="px-5 py-4 border-b border-gray-200 bg-white text-sm">
                        <span class="relative inline-block py-1 font-semibold text-green-900 leading-tight">
                            <span class="relative"><?php echo interpret_currency($account->currency) . ' ' . number_format($transaction->amount, 2); ?></span>
                        </span>
                        </td>
                    </tr>
            <?php endforeach; ?>

            </tbody>
            </table>

        <?php else: ?>
            <div class="p-10">
                You have no transactions yet
            </div>
        <?php endif; ?>

    </div>
</div>