<?php
require_once '../../config/app.php';

if(isset($_SESSION['ADMIN_ID'])) {
    $admin_id = $_SESSION['ADMIN_ID'];

    $admin = R::load('admins', $admin_id);

    // Load user if request referred from users.
    // User should be unauthorized without referral url
    if(isset($_GET['forUser']) && isset($_SERVER['HTTP_REFERER']) || isset($_GET['editCode']) || isset($_GET['deleteCode'])) {
        $user = R::load('users', $_GET['forUser']);
    } 
    
    // else {
    //     die('<pre>Unauthorized request</pre>');
    // }


} else {
    // Redirect user to login
    header('location: login.php');
}

$success = [];
$setFormAction = (isset($_GET['editCode']))? 'edit' : 'new';
$editFormActionName = R::findOne('codes', 'action = ?', [$_GET['editCode']]);;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    
    
    $errors = [];

    if($_POST['formAction'] == 'new') {
        if (empty($_POST['action'])) {
            $errors['action'] = "Code instruction is required to generate code";
        }
        
        if(count($errors) < 1) {
            
            $codesLimit = 3;
            $user = R::load('users', $_POST['user_id']);
            $count = R::count('codes', 'user_id = ?', [$user->id]);
            
            if ($count <= $codesLimit) {
                
                $code = R::dispense('codes');
                
                $instructionNameExists = R::findOne('codes', 'action = ?', [$_POST['action']]);
                
                if ($instructionNameExists != null) {
                    $errors['instruction_exists'] = 'Instruction already exist';
                } else {
                    $code->user_id = $_POST['user_id'];
                    $code->action = $_POST['action'];
                    $code->confirmation_code = $_POST['confirmation_code'];
                    $code->is_used = $_POST['is_used'];
                    
                    $code->created_at = new DateTime('now');
            
                    if($id = R::store($code)) {
                        $success['generated'] = 'Code successfully generated';
                        // header('location: users.php');
                    }
                }
                
            } else {
                $errors['code_limit_exceed'] = 'You have exceeded the number of codes you can generate';
            }
            
        }
    }
    
    if($_POST['formAction'] == 'edit') {
        if (empty($_POST['action'])) {
            $errors['action'] = "Code instruction is required to edit generated code";
        }
        
        if (empty($_POST['confirmation_code'])) {
            $errors['confirmation_code'] = "Confirmation Code required to edit generated code";
        }
        
        
        if (empty($_POST['percentage'])) {
            $errors['percentage'] = "Percentage is required for this code";
        }
        
        //echo $instructionNameExists = R::findOne('codes', 'action = ?', [$_GET['editCode']]); die();
        $instructionNameExists = R::findOne('codes', 'action = ?', [$_GET['editCode']]);
        // if($instructionNameExists != null) {
        //     $errors['action_exists'] = 'Instruction already exist';
        // }
        
        if(count($errors) < 1) {
            $code = R::load( 'codes', $instructionNameExists->id);
            $code->action = $_POST['action'];
            $code->confirmation_code = $_POST['confirmation_code'];
            $code->percentage = $_POST['percentage'];
        
            if($id = R::store($code)) {
                $code = R::findOne('codes', $id);
                $_SESSION['HAS_SUCCESS'] = 'Code successfully edited';
                header('location:'.'generate-code.php?forUser='. $user->id . '&editCode=' . $code->action);
            }
        }
    }

}

if (isset($_GET['deleteCode'])) {
    $code = R::findOne('codes', $_GET['deleteCode']);
    R::trash( $code ); //for one bean
    $_SESSION['HAS_SUCCESS'] = 'Code successfully deleted';
    header('location:'.'generate-code.php?forUser='.$user->id);
    exit();
}


?>

<?php require $base_url . 'app/includes/head.php'; ?>

<?php require $base_url . 'app/includes/nav.php'; ?>


    <div class="container">
        <h1 style="margin: 30px 0">
            <i class="fas fa-user-lock"></i> User: <?= $user->name; ?>
            <span class="pull-right">
                <a href="new_user.php" class="btn btn-primary btn-xs"><i class="fa fa-plus"></i> ADD USER</a>
            </span>
        </h1>
        
        <!-- Put error messages here -->
        <?php if (!empty($success)): ?>
            <div class="alert alert-success text-center">
            <span class="glyphicon glyphicon-thick" aria-hidden="true"></span>
            <?php echo $success['generated']; ?>
             </div>
        <?php endif; ?>
        
         <?php if (isset($_SESSION['HAS_SUCCESS'])): ?>
            <div class="alert alert-success text-center">
            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                <?php echo $_SESSION['HAS_SUCCESS']; ?>
                <?php unset($_SESSION['HAS_SUCCESS']); ?>
            </div>
          <?php endif; ?>
          
          
        <div class="panel panel-default">

            <div class="panel-body">
                <div class="row">
                    <div class="col-md-5">
                        <p>
                            <!-- Put error messages here -->
                            <?php if (!empty($errors)): ?>
                                <div class="alert alert-danger text-center">
                                <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                                <?php echo implode('<p></p>', $errors); ?>
                                 </div>
                            <?php endif; ?>

                        </p>
                        <h4 style="margin-bottom: 15px">Generate codes. You can only generate and run 4 codes at a given time.</h4>
                        <form name="horizontal" action="<?php $_SERVER['PHP_SELF']; ?>" method="post">
                            <input type="hidden" name="user_id" value="<?php if(isset($_GET['forUser'])) echo $_GET['forUser']; ?>">
                            <input type="hidden" name="is_used" value="0">
                            <input type="hidden" name="formAction" value="<?= $setFormAction; ?>">
                            <div class="form-group">
                                <label for="username">Code Instruction</label>
                                <input class="form-control" id="action" type="text" name="action"
                                       value="<?php if(!empty($editFormActionName)) echo $editFormActionName->action; ?>">
                            </div>
                            <div class="form-group">
                                <label for="confirmation_code">Code</label>
                                <input class="form-control" id="confirmation_code" type="text" name="confirmation_code" value="<?php echo ($setFormAction == 'new') ? uniqid() : $editFormActionName->confirmation_code ?>">
                               
                            </div>
                            <?php if($setFormAction != 'new'): ?>
                                
                                <div class="form-group">
                                    <label for="percentage">Loading Percentage</label>
                                    <input class="form-control" id="percentage" type="text" name="percentage" value="<?php if(!empty($editFormActionName)) echo $editFormActionName->percentage; ?>">
                                   
                                </div>
                            
                            <?php endif; ?>
                            
                            <div class="form-group">
                                <button type="submit" class="btn btn-success"><?= strtoupper($setFormAction. ' Code'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="mt-20 text-5xl">
                <div class="flex flex-col">
                    <div class="-my-2 py-2 overflow-x-auto sm:-mx-6 sm:px-6 lg:-mx-8 lg:px-8">
                        <div class="align-middle inline-block min-w-full shadow overflow-hidden sm:rounded-lg border-b border-gray-200">
                                
                                <?php
                                    
                                    $user = R::load('users', $_GET['forUser']);
                                    
                                    $generatedCodes = R::find('codes', 'user_id = ?', [$user->id]);
                                    
                                ?>
                                
                                <?php if(R::count('codes', $user->id) > 1): ?>
                                    <table class="min-w-full">
                                        <thead>
                                        <tr>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Instruction
                                            </th>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Confirmation Code
                                            </th>
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Status
                                            </th>
                                            
                                            <th class="px-6 py-5 border-b border-gray-200 bg-gray-50 text-left text-xl leading-4 font-medium text-gray-700 uppercase tracking-wider p-4">
                                                Percentage
                                            </th>
                                            <th class="px-6 py-3 border-b border-gray-200 bg-gray-50"></th>
                                        </tr>
                                        </thead>
                                    <?php foreach ($generatedCodes as $code): ?>
                                        <tbody class="bg-white">
                                        <tr>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <div class="flex items-center">
                                                    <div class="flex-shrink-0 h-10 w-10">
                                                        <?php if($code->is_used): ?>
                                                    <span class="px-2 inline-flex font-semibold text-green-500 pr-4">
                                                    <i class="fas fa-fingerprint"></i>
                                                </span>
                                                <?php else: ?>
                                                    <span class="px-2 inline-flex font-semibold text-red-500 pr-4">
                                                   <i class="fas fa-fingerprint"></i>
                                                </span>
                                                <?php endif; ?>
                                                        
                                                    </div>
                                                    <div class="ml-4">
                                                        <div class="text-xl leading-5 font-medium text-gray-900">
                                                            <?= $code->action; ?>
                                                        </div>
                                                        <div class="text-xl leading-5 text-gray-500 pt-2">
                                                            <?= $code->confirmation_code; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <div class="flex items-center">
                                                    <div class="text-xl leading-5 text-gray-500 pt-2">
                                                            <?= $code->confirmation_code; ?>
                                                        </div>
                                                </div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <?php if($code->is_used): ?>
                                                    <span class="px-2 inline-flex text-xl leading-5 font-semibold rounded-sm bg-green-100 text-green-500 p-2">
                                                    <i class="fas fa-check"></i> <span class="ml-4">Used</span>
                                                </span>
                                                <?php else: ?>
                                                    <span class="px-2 inline-flex text-xl leading-5 font-semibold rounded-sm bg-red-100 text-red-500 p-2">
                                                    <i class="fas fa-times"></i> <span class="ml-4">Unsed</span>
                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            
                                            <td class="px-6 py-4 whitespace-no-wrap border-b border-gray-200">
                                                <span class="px-2 inline-flex text-xl leading-5 font-semibold rounded-sm bg-green-100 text-green-500 p-2">
                                                    <?php echo $code->percentage; ?> %
                                                </span>
                                            </td>
                                            <td class="px-6 py-4 whitespace-no-wrap text-right border-b border-gray-200 text-xl leading-5 font-medium">
                                                <div>
                                                <span>
                                                   <a href="generate-code.php?forUser=<?= $user->id; ?>&editCode=<?= $code->action; ?>" class="inline-flex justify-center rounded-md border border-gray-300 px-4 py-2 bg-white text-sm leading-5 font-medium text-gray-700 hover:text-gray-500 focus:outline-none focus:border-blue-300 focus:shadow-outline-blue active:bg-gray-50 active:text-gray-800 transition ease-in-out duration-150"><i class="fas fa-user-edit" style="margin-right: 10px"></i> Edit Code</a>
                                               </span>
                                                <span>
                                                    <a href="generate-code.php?forUser=<?= $user->id; ?>&deleteCode=<?= $code->id; ?>" class="inline-flex justify-center rounded-md border border-gray-300 px-4 py-2 bg-white text-sm leading-5 font-medium text-gray-700 hover:text-gray-500 focus:outline-none focus:border-blue-300 focus:shadow-outline-blue active:bg-gray-50 active:text-gray-800 transition ease-in-out duration-150"
                                                      onclick="return confirm('Do you want to delete this?')">
                                                       <i class="fas fa-user-minus" style="margin-right: 10px"></i>
                                                       Delete Code
                                                    </a>
                                                </span>
                                                </div>
                                            </td>
                                        </tr>
                                        </tbody>
                                    <?php endforeach; ?>


                                    </table>

                                <?php else: ?>

                                    <div class="text-center mt-32 text-gray-400 text-gray-600">
                                        <span class="text-5xl">
                                            ¯\_(ツ)_/¯
                                        </span>
                                        <p class="mb-32 mt-4 text-2xl">
                                            You don't have any generated codes
                                        </p>
                                    </div>

                                <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
    </div>

    <?php require $base_url . 'app/includes/footer.php' ?>